function [lam_max, freq] = lamMax(X, y, group, K, loss)
    if nargin < 5
        loss = 'logit';
    end
    p = size(X, 2);
    beta_1 = zeros(p,1);
    [unique_groups, i, j ]= unique(group);
    freq=accumarray(j,1);
    lam_max = -1;
    if strcmp(loss, 'logit')
        %size(y)
        %size(beta_1)
        ys = y ./ (1 + exp(y.*(X*beta_1)));
        %ys = y ./ (1 + exp(beta_1 .* y));
        
        nabla_L = X'*ys ./size(X,1);
    else
        ys = y - X * beta_1;
        nabla_L = (ys'*X)' / size(X, 1);
    end
    for i=1:K
        sub_grp = nabla_L(group == i);
        temp = norm(sub_grp, 2) / sqrt(freq(i));
        if temp > lam_max
            lam_max = temp;
        end
    end
end